/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class SoundLoop {
    private static final int BUFSIZE = 131072;
    private String fileName;
    private URL url;
    private SourceDataLine line;
    private boolean running;

    public SoundLoop(String string) {
        this.fileName = string;
        this.url = this.getClass().getResource(string);
        if (this.url == null) {
            System.err.println("ERROR: SoundLoop couldn't open " + string);
        }
        this.running = false;
    }

    public void stop() {
        this.running = false;
        this.line.close();
    }

    public void play() {
        Thread thread = new Thread(new SoundLoopPlayer());
        thread.start();
    }

    private class SoundLoopPlayer
    implements Runnable {
        int bytesIn;
        int bytesOut;
        byte[] data;

        private SoundLoopPlayer() {
        }

        public void run() {
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(SoundLoop.this.url);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                SoundLoop.this.line = (SourceDataLine)AudioSystem.getLine(info);
                SoundLoop.this.line.open(audioFormat);
                SoundLoop.this.line.start();
                SoundLoop.this.running = true;
                while (SoundLoop.this.running) {
                    this.bytesIn = 0;
                    this.data = new byte[131072];
                    while (this.bytesIn != -1) {
                        this.bytesIn = audioInputStream.read(this.data, 0, this.data.length);
                        if (this.bytesIn < 0) continue;
                        this.bytesOut = SoundLoop.this.line.write(this.data, 0, this.bytesIn);
                    }
                    audioInputStream = AudioSystem.getAudioInputStream(SoundLoop.this.url);
                }
                SoundLoop.this.line.drain();
                SoundLoop.this.line.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

