/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Ged
implements KeyListener {
    private final int WIDTH = 80;
    private final int HEIGHT = 16;
    private LineNumberReader coprocInput;
    private OutputStream coprocOutput;
    private JFrame gedFrame;
    private JTextField gedEntryWindow;
    private JTextArea gedOutputWindow;
    private JCheckBoxMenuItem gedSoundCB;
    private SoundEffects sounds;
    private boolean running = false;
    private boolean debug = false;
    private boolean soundOn = false;
    private boolean soundLoaded = false;

    public void printDebug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    public void exit(int n) {
        if (n >= 0) {
            System.out.println("Thank you for using Ged.");
            System.out.println("Arrrgh!! Command Line!");
        }
        System.exit(n);
    }

    public void runCommand(String[] stringArray) {
        Object object;
        if (this.running) {
            return;
        }
        try {
            object = new ProcessBuilder(stringArray).start();
            this.running = true;
            this.coprocInput = new LineNumberReader(new InputStreamReader(((Process)object).getInputStream()));
            this.coprocOutput = ((Process)object).getOutputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        object = new Thread(new GedRead());
        ((Thread)object).start();
    }

    private void doFileOpen() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this.gedFrame);
        if (n == 0) {
            String string = "e " + jFileChooser.getSelectedFile().getAbsolutePath() + "\n";
            try {
                this.coprocOutput.write(string.getBytes());
                this.coprocOutput.flush();
            }
            catch (IOException iOException) {
                this.gedOutputWindow.setText("ERROR: open failed\n");
            }
            this.printDebug("Running: " + string);
        }
    }

    private void doFileSave() {
        try {
            this.coprocOutput.write("w\n".getBytes());
            this.coprocOutput.flush();
        }
        catch (IOException iOException) {
            this.gedOutputWindow.setText("ERROR: save failed\n");
        }
    }

    private void setSound(OptionsSoundEvent optionsSoundEvent) {
        if (!this.soundLoaded) {
            this.sounds = new SoundEffects("audio/click.wav", "audio/return.wav", "audio/clink.wav");
            this.soundLoaded = true;
        }
        if (optionsSoundEvent == OptionsSoundEvent.TOGGLE) {
            this.soundOn = this.gedSoundCB.getState();
        } else if (optionsSoundEvent == OptionsSoundEvent.ON) {
            this.soundOn = true;
            this.gedSoundCB.setState(true);
        } else if (optionsSoundEvent == OptionsSoundEvent.OFF) {
            this.soundOn = false;
            this.gedSoundCB.setState(false);
        }
    }

    private void setFontSize(int n) {
        if (n < 2 || n > 100) {
            n = 12;
        }
        this.gedEntryWindow.setFont(new Font("Courier New", 0, n));
        this.gedOutputWindow.setFont(new Font("Courier New", 1, n));
        this.gedFrame.pack();
    }

    private void setForeground(Color color) {
        if (color != null) {
            this.gedOutputWindow.setForeground(color);
            this.gedEntryWindow.setForeground(color);
            this.printDebug("FG Color: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        }
    }

    private void setBackground(Color color) {
        if (color != null) {
            this.gedOutputWindow.setBackground(color);
            this.gedEntryWindow.setBackground(color);
            this.printDebug("BG Color: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        }
    }

    private void setColorTheme(String string) {
        Color color;
        Color color2;
        if (string == "Classic") {
            color2 = new Color(0, 200, 0);
            color = new Color(0, 50, 50);
        } else if (string == "Amber") {
            color2 = new Color(200, 200, 0);
            color = new Color(50, 50, 0);
        } else if (string == "Old Ribbon") {
            color2 = new Color(100, 80, 100);
            color = new Color(240, 240, 230);
        } else if (string == "Black") {
            color2 = new Color(245, 245, 245);
            color = new Color(0, 0, 0);
        } else {
            color2 = new Color(0, 0, 0);
            color = new Color(255, 255, 255);
        }
        this.setForeground(color2);
        this.setBackground(color);
    }

    private void doVersion() {
        JOptionPane.showMessageDialog(this.gedFrame, "GUI-ed, 09-May-2006, ver 0.70", "Version", 1);
    }

    private void doGuide() {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("/usr/openwin/bin/xterm -e man ed &");
        }
        catch (IOException iOException) {
            System.out.println("ERROR: on exec");
        }
    }

    private void doLicense() {
        JOptionPane.showMessageDialog(this.gedFrame, "COPYRIGHT: Copyright (c) 2006 Brendan Gregg.\n\nThis program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software Foundation,\nInc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n(http://www.gnu.org/copyleft/gpl.html)\n", "License", 1);
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        this.printDebug("Key: " + c);
        if (this.soundOn) {
            if (c == '\n') {
                this.sounds.play("audio/return.wav");
            } else {
                this.sounds.play("audio/click.wav");
            }
            if (this.gedEntryWindow.getText().length() == 72) {
                this.sounds.play("audio/clink.wav");
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.gedFrame = new JFrame("Ged - GUI ed");
        this.gedFrame.setDefaultCloseOperation(3);
        SplashScreen splashScreen = new SplashScreen(this.gedFrame);
        splashScreen.run();
        this.gedEntryWindow = new JTextField(80);
        this.gedEntryWindow.addKeyListener(this);
        this.gedEntryWindow.setFont(new Font("Courier New", 0, 16));
        this.gedOutputWindow = new JTextArea(16, 80);
        this.gedOutputWindow.setFont(new Font("Courier New", 1, 16));
        this.gedOutputWindow.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.gedOutputWindow);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.setColorTheme("Black");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.doFileOpen();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.doFileSave();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Options");
        jMenuBar.add(jMenu);
        this.gedSoundCB = new JCheckBoxMenuItem("Sound");
        this.gedSoundCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.setSound(OptionsSoundEvent.TOGGLE);
            }
        });
        jMenu.add(this.gedSoundCB);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Font Size");
        for (int i = 6; i < 24; i += 2) {
            jMenuItem = new JMenuItem("" + i);
            jMenu2.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    try {
                        n = Integer.parseInt(jMenuItem.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 16;
                    }
                    Ged.this.setFontSize(n);
                }
            });
        }
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Foreground Color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(Ged.this.gedFrame, "Choose Foreground Color", Ged.this.gedOutputWindow.getForeground());
                Ged.this.setForeground(color);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Background Color");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(Ged.this.gedFrame, "Choose Background Color", Ged.this.gedOutputWindow.getBackground());
                Ged.this.setBackground(color);
            }
        });
        jMenu.add(jMenuItem);
        jMenu2 = new JMenu("Color Theme");
        jMenuItem = new JMenuItem("Black");
        jMenuItem.addActionListener(new GedMenuOptionsColorTheme());
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("White");
        jMenuItem.addActionListener(new GedMenuOptionsColorTheme());
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Classic");
        jMenuItem.addActionListener(new GedMenuOptionsColorTheme());
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Amber");
        jMenuItem.addActionListener(new GedMenuOptionsColorTheme());
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Old Ribbon");
        jMenuItem.addActionListener(new GedMenuOptionsColorTheme());
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu = new JMenu("Help");
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Version");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.doVersion();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Guide");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.doGuide();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("License");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ged.this.doLicense();
            }
        });
        jMenu.add(jMenuItem);
        this.gedFrame.setJMenuBar(jMenuBar);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gedEntryWindow, gridBagConstraints);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.add(jScrollPane);
        jPanel.add(this.gedEntryWindow);
        this.gedFrame.getContentPane().add((Component)jPanel, "Center");
        this.gedEntryWindow.addActionListener(new GedEntryWindowHandler());
        this.gedFrame.pack();
        this.gedFrame.setVisible(true);
        this.gedEntryWindow.requestFocusInWindow();
    }

    public static void main(String[] stringArray) {
        Ged ged = new Ged();
        String[] stringArray2 = new String[2];
        if (stringArray.length > 1) {
            System.err.println("USAGE: ged [filename]");
            ged.exit(-1);
        }
        stringArray2[0] = "/usr/bin/ed";
        stringArray2[1] = stringArray.length == 1 ? stringArray[0] : "";
        ged.createAndShowGUI();
        ged.runCommand(stringArray2);
    }

    private class GedEntryWindowHandler
    implements ActionListener {
        private GedEntryWindowHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Ged.this.printDebug("Entry: " + Ged.this.gedEntryWindow.getText());
            try {
                if (Ged.this.coprocOutput != null) {
                    Ged.this.coprocOutput.write(Ged.this.gedEntryWindow.getText().getBytes());
                    Ged.this.coprocOutput.write(10);
                    Ged.this.coprocOutput.flush();
                }
            }
            catch (IOException iOException) {
                Ged.this.gedOutputWindow.append("ERROR: writing\n");
            }
            Ged.this.gedEntryWindow.setText("");
        }
    }

    private class GedMenuOptionsColorTheme
    implements ActionListener {
        private GedMenuOptionsColorTheme() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            Ged.this.setColorTheme(string);
        }
    }

    private class GedRead
    implements Runnable {
        private byte b;
        private String s;

        private GedRead() {
        }

        public void run() {
            while (Ged.this.running) {
                try {
                    this.s = Ged.this.coprocInput.readLine();
                    if (this.s == null) {
                        break;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                Ged.this.printDebug("Output: " + this.s);
                Ged.this.gedOutputWindow.append(this.s + "\n");
                Ged.this.gedOutputWindow.setCaretPosition(Ged.this.gedOutputWindow.getDocument().getLength());
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Ged.this.running = false;
            Ged.this.exit(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionsSoundEvent {
        ON,
        OFF,
        TOGGLE;

    }
}

